/***************************************************************************************/
// General functions
/***************************************************************************************/
function MM_openBrWindow(theURL,winName,features){ 
		window.open(theURL,winName,features);
}
function getEditorValue(instanceName){  
  // Get the editor instance that we want to interact with.
  var oEditor = FCKeditorAPI.GetInstance( instanceName ) ;
  // Get the editor contents as XHTML.
  return oEditor.GetXHTML( true ) ;  // "true" means you want it formatted.
}
function ConfirmDelete(name)
{ return window.confirm("Do You Want To Delete "+name );}


/////////////////////////////////////////////////////////////////////////////////////////
///////////////   Checks whether a date entered is a valid date or not.  ////////////////
/////////////////////////////////////////////////////////////////////////////////////////
function checkDate(ddVal, mmVal, yyVal) {
	if(ddVal <= 0 || ddVal > 31 || mmVal <= 0 || mmVal > 12 || yyVal <= 0 || yyVal.length != 4) {
		alert("Please enter a valid date");
		return false;
	}
	monthArray = new Array("January", "Febuary", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December");
	if(mmVal == 2) {
		if(yyVal % 4 == 0) {
			if(ddVal > 29) {
				alert("February " + yyVal + " has only 29 days");
				return false;
			}
		}
		else {
			if(ddVal > 28) {
				alert("February " + yyVal + " has only 28 days");
				return false;
			}
		}
	}
	else {
		if(mmVal == 4 || mmVal == 6 || mmVal == 9 || mmVal == 11) {
			if(ddVal > 30) {
				alert(monthArray[mmVal-1] + " has only 30 days");
				return false;
			}
		}
	}
	return true;
}

/////////////////////////////////////////////////////////////////////////////////////////
// Checks whether a string is a valid email address.
/////////////////////////////////////////////////////////////////////////////////////////
function checkEmail(emailString) {
	splitVal = emailString.split('@');
	
	if(splitVal.length <= 1) {
		alert("Please enter a valid email address");
		return false;
	}
	if(splitVal[0].length <= 0 || splitVal[1].length <= 0) {
		alert("Please enter a valid email address");
		return false;
	}
	
	splitDomain = splitVal[1].split('.');
	if(splitDomain.length <= 1) {
		alert("Please enter a valid email address");
		return false;
	}
	if(splitDomain[0].length <= 0 || splitDomain[1].length <= 1) {
		alert("Please enter a valid email address");
		return false;
	}
	return true;
}

/////////////////////////////////////////////////////////////////////////////////////////
// Removes the leading and trailing spaces in a strings and returns the trimmed string //
/////////////////////////////////////////////////////////////////////////////////////////
function trimSpaces(stringValue) {
	// Checks the first occurance of spaces and removes them
	for(i = 0; i < stringValue.length; i++) {
		if(stringValue.charAt(i) != " ") {
			break;
		}
	}
	if(i > 0) {
		stringValue = stringValue.substring(i);
	}
	
	// Checks the last occurance of spaces and removes them
	strLength = stringValue.length - 1;
	for(i = strLength; i >= 0; i--) {
		if(stringValue.charAt(i) != " ") {
			break;
		}
	}
	if(i < strLength) {
		stringValue = stringValue.substring(0, i + 1);
	}
	
	// Returns the string after removing leading and trailing spaces.
	return stringValue;
}

/////////////////////////////////////////////////////////////////////////////////////////
//************* Check whether a string contain permitted characters only **************//
/////////////////////////////////////////////////////////////////////////////////////////
function checkAllowedChars(strToCheck, allowedChars)
{
     var acLen     = allowedChars.length;
     var stcLen     = strToCheck.length;
     strToCheck     = strToCheck.toLowerCase();
     var i;
     var j;
     var rightCount = 0;
     for(i = 0; i < acLen; i++)
     {
          switch(allowedChars.charAt(i))
          {
          case 'A':
               for(j = 0; j< stcLen; j++)
               {
                    rightCount += strToCheck.charAt(j) >= 'a' && strToCheck.charAt(j) <= 'z';
               }
               break;
          case 'N':
               for(j = 0; j< stcLen; j++)
               {
                    rightCount += strToCheck.charAt(j) >= '0' && strToCheck.charAt(j) <= '9';
               }
               break;
          default:
               for(j = -1; -1 != (j = strToCheck.indexOf(allowedChars.charAt(i), j + 1)); rightCount++);
               break;
          }
     }
     if(rightCount == stcLen)
     {
          return true;
     }
     return false;
}

/////////////////////////////////////////////////////////////////////////////////////////
//// Checks whether the first date argument is less than the second date argument
//// Date arguments should be in the format - dd/mm/yyyy
/////////////////////////////////////////////////////////////////////////////////////////
function checkDateDifference(lowDate, highDate, comparison) {
	lowDateSplit = lowDate.split('/');
	highDateSplit = highDate.split('/');

	date1 = new Date();
	date2 = new Date();

	date1.setDate(lowDateSplit[0]);
	date1.setMonth(lowDateSplit[1] - 1);
	date1.setYear(lowDateSplit[2]);

	date2.setDate(highDateSplit[0]);
	date2.setMonth(highDateSplit[1] - 1);
	date2.setYear(highDateSplit[2]);

	if(comparison == "eq") {
		if(date1.getTime() == date2.getTime()) {
			return true;
		}
		else {
			return false;
		}
	}
	else if(comparison == "lt") {
		if(date1.getTime() < date2.getTime()) {
			return true;
		}
		else {
			return false;
		}
	}
	else if(comparison == "gt") {
		if(date1.getTime() > date2.getTime()) {
			return true;
		}
		else {
			return false;
		}
	}
	else if(comparison == "le") {
		if(date1.getTime() <= date2.getTime()) {
			return true;
		}
		else {
			return false;
		}
	}
	else if(comparison == "ge") {
		if(date1.getTime() >= date2.getTime()) {
			return true;
		}
		else {
			return false;
		}
	}
}

function formatCheck(dateStr) {
	dateSplit = dateStr.split("/");
	if(dateSplit.length != 3) {
		return false;
	}
	if(trimSpaces(dateSplit[0]).length <= 0 || trimSpaces(dateSplit[1]).length <= 0 || trimSpaces(dateSplit[2]).length <= 0) {
		return false;
	}
	return true;
}
//function to open in custom window
function openWindow(url,window_name,winWidth,winHeight,fscroll,position) {
	sWidth = screen.availWidth;
	sHeight = screen.availHeight;

	if(!position || position.length <= 0) {
		sLeft = (sWidth - winWidth) / 2;
		sTop = (sHeight - winHeight) / 2;
	}else if(position == 'TL') { //Top left
		sLeft = 0;
		sTop = 0;
	}else if(position == 'TR') { //Top right
		sLeft = (sWidth - winWidth) - 30;
		sTop = 0;
	}else if(position == 'BL') { //Bottom left
		sLeft = 0;
		sTop = (sHeight - winHeight) - 50;
	}else if(position == 'BR') { //Bottom left
		sLeft = (sWidth - winWidth) - 30;
		sTop = (sHeight - winHeight) - 50;
	}

	if(fscroll == '') {fscroll = 0}
	window.open(url,window_name,"width=" + winWidth + ",height=" + winHeight + ",top=" + sTop + ",left=" + sLeft + ",toolbar=0,menubar=0,status=0,scrollbars=" + fscroll + ",resizable=0");
}
//To print Current Date in the format D-Month Name-Year
function writeDate() 
{
	var monthNames = new Array ("January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December");
	var dayNames = new Array ("Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday");
	var now = new Date();
	var amPm = (now.getHours() < 12) ? "am" : "pm";
	var hour = (now.getHours() > 12) ? (now.getHours() - 12) : (hour == 0) ? "12" : now.getHours();
	var min = (now.getMinutes() < 10) ? ("0" + now.getMinutes()) : (now.getMinutes());
	document.write (now.getDate()+" - "+monthNames[now.getMonth()] + " - " +now.getYear() );
}

function checkTimings()
{
	if(document.forms[0].timings.value=="")
	{
		alert("Please enter timing");
		document.forms[0].timings.focus();
		return false;
	}
	document.forms[0].toDo.value="add";
}

function editTiming(ndx,tim_id)
{
	if(document.forms[1].elements["elm[]"][ndx].value=="")
	{
		alert("Please enter timing");
		document.forms[1].elements["elm[]"][ndx].focus();
		return false;
	}
	document.forms[1].toDo.value="edit";
	document.forms[1].tim_id.value= tim_id;
	document.forms[1].tim_val.value = document.forms[1].elements["elm[]"][ndx].value;
}

function delTiming(tim_id)
{
	if(confirm("Are you sure you want to delete the selected record?"))
	{
		document.forms[1].toDo.value="delete";
		document.forms[1].tim_id.value= tim_id;	
	}
	else return false;
}

function addRooms()
{
	if(trimSpaces(document.forms[0].rname.value)=="")
	{
		alert("Please enter Name of Room");
		document.forms[0].rname.focus();
		return false;	
	}
	tot= document.forms[0].tot.value;
	availNdx = 3;
	noRooms = true;
	for(x=0;x<tot;x++)
	{
		rateNdx = availNdx - 2;
		taxNdx = availNdx - 1;
		if(document.forms[0].elements[availNdx].checked)
		{
			noRooms = false;
			if(document.forms[0].elements[rateNdx].value=="")
			{
				alert("Please enter Rate");
				document.forms[0].elements[rateNdx].focus();
				return false;
			}
			if(document.forms[0].elements[taxNdx].value=="")
			{
				alert("Please enter Tax");
				document.forms[0].elements[taxNdx].focus();
				return false;
			}
			availNdx = availNdx + 3;
		}
	}
	if(noRooms)
	{
		alert("Please select at least one Room type and enter Rate and Tax");
		return false;
	}
//from date validation	
dd = document.forms[0].from_day.options[document.forms[0].from_day.selectedIndex].value;
mm = document.forms[0].from_month.options[document.forms[0].from_month.selectedIndex].value;
yy = document.forms[0].from_year.options[document.forms[0].from_year.selectedIndex].value;
if (!checkDate(dd,mm,yy))
return false;

	var tDate = new Date();
	if (mm.length < 2) mm = "0" + mm;
	if (dd.length < 2) dd = "0" + dd;
	sDate = yy + mm + dd;

	sMonth = (tDate.getMonth() + 1).toString();
	sDay = (tDate.getDate()).toString();
	sYear = (tDate.getFullYear()).toString();
	if (sMonth.length < 2) sMonth = "0" + sMonth;
	if (sDay.length < 2) sDay = "0" + sDay;
	sCurDate = sYear + sMonth + sDay;
	
	if (sDate < sCurDate) {
		window.alert("You cannot specify a Date prior to today.");
		document.forms[0].focus();
		return false;
	}
	fromDate = sDate
	
//to date validation
dd = document.forms[0].to_day.options[document.forms[0].to_day.selectedIndex].value;
mm = document.forms[0].to_month.options[document.forms[0].to_month.selectedIndex].value;
yy = document.forms[0].to_year.options[document.forms[0].to_year.selectedIndex].value;
if (!checkDate(dd,mm,yy))
return false;

	var tDate = new Date();
	if (mm.length < 2) mm = "0" + mm;
	if (dd.length < 2) dd = "0" + dd;
	sDate = yy + mm + dd;

	sMonth = (tDate.getMonth() + 1).toString();
	sDay = (tDate.getDate()).toString();
	sYear = (tDate.getFullYear()).toString();
	if (sMonth.length < 2) sMonth = "0" + sMonth;
	if (sDay.length < 2) sDay = "0" + sDay;
	sCurDate = sYear + sMonth + sDay;
	
	if (sDate < sCurDate) {
		window.alert("You cannot specify a Date prior to today.");
		document.forms[0].focus();
		return false;
	}

	if (sDate < fromDate) {
		window.alert("You cannot specify a Date prior to From Date.");
		document.forms[0].focus();
		return false;
	}
	document.forms[0].frmAction.value="insert";

}

function addMap()
{
	if(trimSpaces(document.forms[0].map.value)=="")
	{
		alert("Please Select map image to upload");
		document.forms[0].map.focus();
		return false;	
	}
	document.forms[0].frmAction.value="update";
}
function delMap()
{
	if(confirm("Are you sure you want to delete the location map?"))
	{
		document.forms[0].frmAction.value="delete";
		document.forms[0].submit();
	}
}
function addPalette()
{
	if(trimSpaces(document.forms[0].map.value)=="")
	{
		alert("Please Select image to upload");
		document.forms[0].map.focus();
		return false;	
	}
	document.forms[0].frmAction.value="update";
}
function delPalette()
{
	if(confirm("Are you sure you want to delete the colour palette?"))
	{
		document.forms[0].frmAction.value="delete";
		document.forms[0].submit();
	}
}
function checkSearch(){

	if(trimSpaces(document.frmSearch.txtKey.value)==""){
		alert("Please enter  keyword");
		document.frmSearch.txtKey.focus();
		return false;
	}
		
}
function chkReq_survey()
{
	if(document.frmSurvey.sb_company.value==""){
		alert("Please Enter Company.");
		document.frmSurvey.sb_company.focus();
		return false;
	}
	if(document.frmSurvey.sb_name.value==""){
		alert("Please Enter Name.");
		document.frmSurvey.sb_name.focus();
		return false;
	}
	if(!checkEmail(document.frmSurvey.sb_email.value))
	{
		document.frmSurvey.sb_email.select();
		return false;
	}
	if(document.frmSurvey.sb_phone.value=="")
	{	
		alert("Please Enter Phone Number.");
		document.frmSurvey.sb_phone.focus();
		return false;
	}
}
	function checkSearch(frm)
	{
	if(frm.txtKey.value=="")
	{
	alert("Please enter search key!");
	frm.txtKey.focus();
	return false;
	}
	}