<?php
  require_once('tblOp.php');
  class doctors extends tblOp
  {
	

  	function doctors($tablename)
  	{
  		$this->todays_date = date("Y-m-d");
  		parent::__construct($tablename);
  	}
  	function get_doctor_details($cond)
  	{
  		$sql = " SELECT 
  		         	d.*, CONCAT(d.first_name,' ',d.last_name) AS format_name, s.speciality_name, l.location_name,
  		          	n.nationality, pi.pi_image1
  		         FROM 
  		         	doctors AS d
  		         INNER JOIN 
  		         	speciality AS s ON d.speciality_id=s.speciality_id
  		         INNER JOIN 
  		         	location AS l ON d.location_id=l.location_id
  		         INNER JOIN
  		         	nationality AS n ON d.nationality_id=n.nationality_id
  		         LEFT JOIN 
  		         	profile_image AS pi ON d.doctor_id=pi.doctor_id
  		         WHERE
  		         	$cond 
  		       ";
  		       //echo $sql;exit;
  		return $this->joinQuery($sql);
  	}
  	function get_doctor_details_listing($cond,$from,$count)
  	{
  		
  		$sql = " SELECT 
  		         	d.*, CONCAT(d.first_name,' ',d.last_name) AS format_name, s.speciality_name, l.location_name,
  		          	n.nationality, pi.pi_image1
  		         FROM 
  		         	doctors AS d
  		         INNER JOIN 
  		         	speciality AS s ON d.speciality_id=s.speciality_id
  		         INNER JOIN 
  		         	location AS l ON d.location_id=l.location_id
  		         INNER JOIN
  		         	nationality AS n ON d.nationality_id=n.nationality_id
  		         LEFT JOIN 
  		         	profile_image AS pi ON d.doctor_id=pi.doctor_id
  		         WHERE
  		         	$cond 
  		       ";
  		      // echo $sql;exit;
  		return $this->limitQuery($sql,$from,$count);
  	}
 	
 	
 	function getDoctorsListInSearch($cond,$from,$count,$order=NULL){
 		 
 		 $order=$order ? " order by $order" : "";
 		  $sql="(select d.doctor_id,d.first_name,d.last_name,d.designation,hm.folder_name, hm.hospitalName,sm.speciality,d.pi_image1 from doctors d 
 		inner join hospitalMaster hm on hm.hospitalId=d.hospitalId
 		inner join specialityMaster sm on sm.specialityId=d.specialityId  
 		where $cond and  d.hospitalId='{$_SESSION['hospitalId']}')
 		 UNION
 		 (select d.doctor_id,d.first_name,d.last_name,d.designation,hm.folder_name, hm.hospitalName,sm.speciality,d.pi_image1 from doctors d inner join  specialityMaster sm on sm.specialityId=d.specialityId inner join doctor_hospitals as dh on dh.doctor_id=d.doctor_id inner join  hospitalMaster hm on hm.hospitalId=dh.hospitalId
 		where $cond and  dh.hospitalId='{$_SESSION['hospitalId']}') $order
 		
 		";
 		return $this->limitQuery($sql,$from,$count);
 	}
 	
 	function getDoctorsListInSearch_count($cond){
 			 $sql="(select d.doctor_id from doctors d 
 		inner join hospitalMaster hm on hm.hospitalId=d.hospitalId
 		inner join specialityMaster sm on sm.specialityId=d.specialityId  
 		where $cond and  d.hospitalId='{$_SESSION['hospitalId']}')
 		 UNION
 		 (select d.doctor_id from doctors d inner join  specialityMaster sm on sm.specialityId=d.specialityId inner join doctor_hospitals as dh on dh.doctor_id=d.doctor_id inner join  hospitalMaster hm on hm.hospitalId=dh.hospitalId
 		where $cond and  dh.hospitalId='{$_SESSION['hospitalId']}')
 		
 		";
 		return $this->custom_count($sql);
 	}
 	
 	function getDoctorsListInSearchGroup($cond,$from,$count,$order=NULL){
 		 
 		 $order=$order ? " order by $order" : "";
 		  $sql="(select d.doctor_id,d.first_name,d.last_name,d.designation,hm.folder_name, hm.hospitalName,sm.speciality,d.pi_image1 from doctors d 
 		inner join hospitalMaster hm on hm.hospitalId=d.hospitalId
 		inner join specialityMaster sm on sm.specialityId=d.specialityId  
 		where $cond )
 		 UNION
 		 (select d.doctor_id,d.first_name,d.last_name,d.designation,hm.folder_name, hm.hospitalName,sm.speciality,d.pi_image1 from doctors d inner join  specialityMaster sm on sm.specialityId=d.specialityId inner join doctor_hospitals as dh on dh.doctor_id=d.doctor_id inner join  hospitalMaster hm on hm.hospitalId=dh.hospitalId
 		where $cond ) $order
 		
 		";
 		return $this->limitQuery($sql,$from,$count);
 	}
 	
 	function getDoctorsListInSearch_countGroup($cond){
 			 $sql="(select d.doctor_id from doctors d 
 		inner join hospitalMaster hm on hm.hospitalId=d.hospitalId
 		inner join specialityMaster sm on sm.specialityId=d.specialityId  
 		where $cond )
 		 UNION ALL
 		 (select d.doctor_id from doctors d inner join  specialityMaster sm on sm.specialityId=d.specialityId inner join doctor_hospitals as dh on dh.doctor_id=d.doctor_id inner join  hospitalMaster hm on hm.hospitalId=dh.hospitalId
 		where $cond )
 		
 		";
 		return $this->custom_count($sql);
 	}
 	
 	
 	
 	function JointDoctorName($strKey,$strVal,$selected,$condition,$order,$fields){
 	
 	         $sql="select $fields from doctors where $condition order by $order ";       
 	         
 	         return $this->JointgetOptions($strKey, $strVal,$selected,$sql);   
 	}
 	
 	function JointDoctorNameAppointment($strKey,$strVal,$selected,$condition,$order,$fields){
 	
 	         //$sql="select $fields from doctors where $condition order by $order ";       
 	         $sql="select $fields from doctors as d inner join hospitalMaster as h on h.hospitalId=d.hospitalId where  $condition order by $order";
 	         
 	         return $this->JointgetOptions($strKey, $strVal,$selected,$sql);   
 	}
 	
 	function JointDoctorHospitalWise($strKey,$strVal,$selected,$condition,$order,$fields){
 	
 	    	         
 	         
 	         	 $sql="(select $fields from doctors d 
 		inner join hospitalMaster hm on hm.hospitalId=d.hospitalId
 		inner join specialityMaster sm on sm.specialityId=d.specialityId  
 		where $condition and  d.hospitalId='{$_SESSION['hospitalId']}')
 		 UNION
 		 (select $fields from doctors d inner join  specialityMaster sm on sm.specialityId=d.specialityId inner join doctor_hospitals as dh on dh.doctor_id=d.doctor_id inner join  hospitalMaster hm on hm.hospitalId=dh.hospitalId
 		where $condition and  dh.hospitalId='{$_SESSION['hospitalId']}')
 		
 		";
 	         
 	         
 	         
 	         return $this->JointgetOptions($strKey, $strVal,$selected,$sql);   
 	}
 	
 	
 	function getDoctorHospitals($id)
 	{ 
 	   $sql = " 
 	   (SELECT hospitalName, HM.hospitalId from hospitalMaster HM left Join  doctors D ON D.hospitalId = HM.hospitalId where D.doctor_id=$id) UNION 	   
 	   (SELECT hospitalName, HM.hospitalId from hospitalMaster HM JOIN doctor_hospitals D ON D.hospitalId = HM.hospitalId where D.doctor_id=$id)" ;
 	 
 	   return $this->getAll_join($sql);
 	}
 	
 	function SearchDoctors($condition,$order,$fields){
 	        $sql="select $fields from doctors as d inner join hospitalMaster as h on h.hospitalId=d.hospitalId where $condition order by $order";
 	        return $this->getAll_join($sql);
 	        
 	}
	function getOptionsLocationDoctor($strKey,$strVal,$selected,$condition,$order){
		  $sql="(SELECT l.locationId,l.location from locationMaster as l inner join hospitalMaster as hm on hm.locationId=l.locationId inner join doctors as d on d.hospitalId=hm.hospitalId 
			WHERE $condition
			GROUP BY l.location ) UNION (SELECT l.locationId,l.location from locationMaster as l inner join hospitalMaster as hm on hm.locationId=l.locationId  inner join doctor_hospitals as dh on dh.hospitalId=hm.hospitalId inner join doctors as d on d.doctor_id=dh.doctor_id
			WHERE $condition and d.status='1'
			GROUP BY l.location) order by location";
			  	    
			return $this->JointgetOptions($strKey, $strVal,$selected,$sql);   
	}
 
  }
?>

