<?php
	require_once('tblOp.php');
	class speciality extends tblOp
	{
		var $todays_date;
		var $tablename    = "specialityMaster";
		var $primaryKey   = "specialityId";
		var $table_fields =  array('specialityId'=>"", 'speciality'=>"", 'image'=>"", 'details'=>"",
					           'status'=>"",'createdDate'=>"",'createdBy'=>"",
					           'specialityTypeId'=>""
					          );

	  	function speciality($tablename)
	  	{
	  		$this->todays_date = date("Y-m-d");
	  		parent::__construct($tablename);
	  	}
	  	function get_speciality_details($cond)
	  	{
	  		$sql = " SELECT 
	  		         	d.*, CONCAT(d.first_name,' ',d.last_name) AS format_name, s.speciality_name, l.location_name,
	  		          	n.nationality, pi.pi_image1
	  		         FROM 
	  		         	doctors AS d
	  		         INNER JOIN 
	  		         	speciality AS s ON d.speciality_id=s.speciality_id
	  		         INNER JOIN 
	  		         	location AS l ON d.location_id=l.location_id
	  		         INNER JOIN
	  		         	nationality AS n ON d.nationality_id=n.nationality_id
	  		         LEFT JOIN 
	  		         	profile_image AS pi ON d.doctor_id=pi.doctor_id
	  		         WHERE
	  		         	$cond 
	  		       ";
	  		       //echo $sql;exit;
	  		return $this->joinQuery($sql);
	  	}
	function assignedSpeciality($strKey,$strVal,$selected,$condition,$order){
  	       
  	      
  	       $sql="select s.speciality,s.specialityId from specialityMaster as s inner join hospitalSettings as h on h.specialityId=s.specialityId where $condition group by s.specialityId order by $order ";
  	    return $this->JointgetOptions($strKey, $strVal,$selected,$sql);   
  	}
  	
  	
  	function assignedSpecialityLocation($strKey,$strVal,$selected,$condition,$order){
  	       
  	      
  	        $sql="select s.speciality,s.specialityId from specialityMaster as s inner join hospitalSettings as h on h.specialityId=s.specialityId inner join hospitalMaster as hm on hm.hospitalId=h.hospitalId  where $condition group by s.specialityId order by $order ";
  	    return $this->JointgetOptions($strKey, $strVal,$selected,$sql);   
  	}

	function assignedSpecialityLocationDoctor($strKey,$strVal,$selected,$condition,$order){
  	       
  	      
  	        $sql="SELECT s.speciality, s.specialityId
FROM specialityMaster AS s
INNER JOIN doctors AS d ON d.specialityId = s.specialityId
LEFT JOIN doctor_hospitals AS dh ON dh.doctor_id = d.doctor_id
WHERE $condition
GROUP BY s.specialityId order by $order";
  	    
return $this->JointgetOptions($strKey, $strVal,$selected,$sql);   

		



  	}

  	function getSpecialitybyType()
  	{
  	   $sql = " SELECT speciality,specialityId from specialityMaster SM INNER JOIN specialityType ST ON SM.specialityTypeId=ST.specialityTypeId ORDER BY specialityType DESC";
  	   return $this->getLimit_join(0,18,$sql,"speciality");
  	}
  	function getAllTreatments($condition,$order)
  	{
  	   $sql = "SELECT t.treatment,t.treatmentId from treatmentMaster as t inner join hospitalSettings as h on h.treatmentId=t.treatmentId where $condition group by t.treatmentId order by $order";
  	   //echo $sql;
  	   return $this->getAll_join($sql);
  	}
  	function getAllOtherHospitals($condition)
  	{
  	$sql = "SELECT  hospitalName,location,folder_name from hospitalSettings HS JOIN hospitalMaster HM ON HS.hospitalId= HM.hospitalId JOIN locationMaster LM ON HM.locationId=LM.locationId  where $condition AND HM.status='1' GROUP BY HS.hospitalId";
  	 return $this->getAll_join($sql);
  	
  	}
  	function getAllTreatmentsOfHospital($id,$hid)
  	{
  	   $sql = "SELECT treatment,TM.treatmentId from treatmentMaster TM JOIN hospitalSettings HS ON TM.treatmentId=HS.treatmentId where TM.specialityId=".$id." AND hospitalId=".$hid." AND status='1' ORDER BY treatment";
  	  //echo $sql;
  	   return $this->getAll_join($sql);
  	}
  	function getOtherHospitalSpecil($id,$hid)
  	{
  	  $sql = "SELECT  HM.hospitalName,location,HM.hospitalId,folder_name from hospitalSettings HS JOIN hospitalMaster HM ON HS.hospitalId= HM.hospitalId LEFT JOIN locationMaster LM ON HM.locationId=LM.locationId  where HS.specialityId=".$id." AND HM.status='1' AND HS.hospitalId!=".$hid." and HM.group_status='0' GROUP BY HS.hospitalId";
  	  //echo $sql;
  	   return $this->getAll_join($sql);
  	}
  	function getSingleTreatment($id,$hid)
  	{
  	$sql = "SELECT TM.treatmentId,treatment from treatmentMaster TM JOIN hospitalSettings HS ON TM.treatmentId=HS.treatmentId WHERE TM.specialityId=".$id." AND hospitalId=".$hid." AND status='1' ORDER BY treatment";	
 //echo $condi;
  return $this->getAll_join($sql);
  	}
  	function getDocLocation($id)
  	{
  	  $sql = "SELECT location FROM locationMaster LM JOIN hospitalMaster HM on LM.locationId=HM.locationId WHERE HM.hospitalId=".$id;
  	 // echo $sql;
  	  
  	  return $this->getRow_join($sql);
  	}
  	function getLimitJoint($start=NULL,$limit=NULL,$condition,$order,$fields=NULL){
  	       
  	       if($limit)
  	         $limit= 'limit '.$start.','.$limit;
  	        else
  	                $limit="";
  	       
  	        echo $sql="select $fields from specialityMaster as s inner join hospitalSettings as h on h.specialityId=s.specialityId where $condition  group by s.specialityId order by $order $limit";
  	         return $this->getAll_join($sql);
  	}
		
	function getspeciality($start=NULL,$limit=NULL,$condition,$order,$fields=NULL){
  	       
  	       if($limit)
  	         $limit= 'limit '.$start.','.$limit;
  	        else
  	                $limit="";
  	       
  	        /*$sql="select $fields from specialityMaster as s inner join hospitalSettings as h on h.specialityId=s.specialityId
		where $condition  group by s.specialityId order by $order $limit";*/
		$sql="SELECT $fields FROM specialityMaster AS s
			INNER JOIN specialityDetails AS h ON h.specialityId = s.specialityId
			LEFT JOIN specialityManagement sm ON sm.specialityId = s.specialityId
		WHERE $condition GROUP BY s.specialityId ORDER BY s.priority $limit";

              
               
  	       return $this->getAll_join($sql);
  	}
	
	
	function getspecialitySecond($start=NULL,$limit=NULL,$condition,$order,$fields=NULL){
  	       
  	       if($limit)
  	         $limit= 'limit '.$start.','.$limit;
  	        else
  	                $limit="";
  	       
  	        /*$sql="select $fields from specialityMaster as s inner join hospitalSettings as h on h.specialityId=s.specialityId
		where $condition  group by s.specialityId order by $order $limit";*/
			$sql="SELECT $fields FROM specialityMaster AS s
			INNER JOIN specialityDetails AS h ON h.specialityId = s.specialityId
			LEFT JOIN specialityManagement sm ON sm.specialityId = s.specialityId and  sm.hospital_id='{$_SESSION['hospitalId']}'
		WHERE $condition GROUP BY s.specialityId ORDER BY sm.priority $limit";

              
               
  	       return $this->getAll_join($sql);
  	}
	
	
  	
}
?>

